/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers;

import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.Utils;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Event;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.Listener;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.ExceptionEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.ListenerExceptionEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers.ListenerManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractListenerManager
implements ListenerManager {
    private static final Logger log = LogManager.getLogger();
    private final Logger sublog = LogManager.getLogger(this.getClass());

    protected void executeListener(Listener listener, Event event) {
        this.executeListener(listener, event, "Failed in " + this.getClass().getName());
    }

    protected void executeListener(Listener listener, Event event, String debug) {
        try {
            listener.onEvent(event);
        }
        catch (Exception listenerException) {
            if (event instanceof ExceptionEvent) {
                log.error("Encountered exception while processing {}, NOT dispatching another ExceptionEvent to stop potential StackOverflow", event.getClass(), (Object)listenerException);
            }
            this.onEvent(new ListenerExceptionEvent((PircBotX)event.getBot(), listenerException, debug, listener, event));
        }
    }

    @Override
    public void onEvent(Event event) {
        if (event.getBot() != null) {
            Utils.addBotToMDC(event.getBot());
        }
        if (PircBotX.DEBUG_LEVEL != null) {
            this.sublog.log(PircBotX.DEBUG_LEVEL, "Recieved event " + event);
        }
    }

    protected static class ExecuteListenerRunnable
    implements Runnable {
        protected final AbstractListenerManager listenerManager;
        protected final Listener listener;
        protected final Event event;

        @Override
        public void run() {
            this.listenerManager.executeListener(this.listener, this.event);
        }

        public ExecuteListenerRunnable(AbstractListenerManager listenerManager, Listener listener, Event event) {
            this.listenerManager = listenerManager;
            this.listener = listener;
            this.event = event;
        }
    }
}

